/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.data.material;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.minecraft.class_2960;
import net.minecraft.class_7403;
import slimeknights.mantle.data.GenericDataProvider;
import slimeknights.tconstruct.library.data.material.AbstractMaterialDataProvider;
import slimeknights.tconstruct.library.materials.definition.MaterialId;
import slimeknights.tconstruct.library.materials.stats.IMaterialStats;

public abstract class AbstractMaterialStatsDataProvider
extends GenericDataProvider {
    private final Map<MaterialId, List<IMaterialStats>> allMaterialStats = new HashMap<MaterialId, List<IMaterialStats>>();
    private final AbstractMaterialDataProvider materials;

    public AbstractMaterialStatsDataProvider(FabricDataOutput output, AbstractMaterialDataProvider materials) {
        super(output, "tinkering/materials/stats");
        this.materials = materials;
    }

    protected abstract void addMaterialStats();

    public CompletableFuture<?> method_10319(class_7403 cache) {
        this.addMaterialStats();
        Set<MaterialId> materialsGenerated = this.materials.getAllMaterials();
        for (MaterialId material : materialsGenerated) {
            if (this.allMaterialStats.containsKey(material)) continue;
            throw new IllegalStateException(String.format("Missing material stats for '%s'", material));
        }
        ArrayList futures = new ArrayList();
        this.allMaterialStats.forEach((materialId, materialStats) -> futures.add(this.saveThing(cache, (class_2960)materialId, this.convert((List<IMaterialStats>)materialStats))));
        return CompletableFuture.allOf((CompletableFuture[])futures.toArray(CompletableFuture[]::new));
    }

    protected void addMaterialStats(MaterialId location, IMaterialStats ... stats) {
        this.allMaterialStats.computeIfAbsent(location, materialId -> new ArrayList()).addAll(Arrays.asList(stats));
    }

    private JsonWrapper convert(List<IMaterialStats> stats) {
        Map<class_2960, IMaterialStats> wrappedStats = stats.stream().collect(Collectors.toMap(IMaterialStats::getIdentifier, stat -> stat));
        return new JsonWrapper(wrappedStats);
    }

    private static class JsonWrapper {
        private final Map<class_2960, IMaterialStats> stats;

        public JsonWrapper(Map<class_2960, IMaterialStats> stats) {
            this.stats = stats;
        }
    }
}

